Attribute VB_Name = "modCRLimit"
'*********************************************************************************************
'*                                                                                           *
'* Module to display helpful messages to a programmer testing a program which uses CClevRes. *
'*                                                                                           *
'*********************************************************************************************
'
'When the program being tested does not run problem this will be refered to as a 'limitation'
'as apposed to an 'error'. The word 'error' implies that the programmer is doing something wrong.
'The word 'limitation' is often more appropriate since that implies that the program itself
'(in this case the CClevRes class) is not capable of handling all possible situations.
'
Option Explicit
Public Sub HelpfulMsgBox(sFormName As String, sProblem As String, Optional vntSolution As Variant)
Attribute HelpfulMsgBox.VB_Description = "[Private] Displays a modal helpful message box for a programmer testing a program which uses CClevRes. It explains why the program will not run correctly and possibly suggests what can be done to improve the situation."
   'Useful MsgBox to help programmers debug their programs
   Dim sMessage As String, nResponse As Integer
   Dim sCR As String 'Carriage return
   sCR = Chr(10) & Chr(13)
   sMessage = "Sorry to stop but " & sProblem & sCR & sCR
   If Not IsMissing(vntSolution) Then
      sMessage = sMessage & "Recommended solution: " & vntSolution & sCR & sCR
   End If
   sMessage = sMessage & "Do you want to debug the program now?" & sCR _
    & "(Answer 'Yes' is recommended, if program continues other problems may occur while " _
    & "running this program)"
   nResponse = MsgBox(sMessage, vbYesNoCancel + vbInformation, "CClevRes Debugging Help for Form - " _
    & sFormName)
   Select Case nResponse
      Case vbYes
         Stop
      Case vbCancel
         End
      Case vbNo   'continue program
   End Select
End Sub


Public Sub Limit(nLimitation As Integer, Optional vntForm, Optional vntOtherInfo)
Attribute Limit.VB_Description = "Initiates the appropriate debugging help message to be displayed for limitation number nLimitation."
   Dim sProblem As String, sSolution As String, sPhrase As String, sFormName As String
   If Not (IsMissing(vntForm)) Then
      sFormName = vntForm.Name
   Else
      sFormName = "???"
   End If
   Select Case nLimitation
      Case 101
         sProblem = "a line control cannot be restricted. "
         sSolution = "Place the line control inside a container (e.g. a Picture Box with it's " _
          & "BorderStyle set to 0), then restrict the Picture Box the way you would like the " _
          & "line control to be restricted."
      Case 102
         sProblem = "the control called '" & vntOtherInfo & "' which you wanted to pass to " _
          & "the CClevRes Class does not seam to exist on form '" & sFormName & "'."
         sSolution = "Maybe the name of this control is incorrectly spelt somewhere. " _
          & "Alternatively, it could be that the control did not exist on the form when the " _
          & "Form property of this instance of the CClevRes Class was set, but was added " _
          & "later on. If so the ResetDimensions method should be activated immediately " _
          & "after adding that control."
      Case 103
         sProblem = "the Form property of the CClevRes Class was set before the " _
          & "MDIForm property for that instance of the class was set."
         sSolution = "At the beginning of the required MDI child's Form_Load event " _
          & "first set the CClevRes.MDIForm property, then set the form's original " _
          & "width and height sizes (in twips), only after this should the Form property be set."
      Case 104
         sProblem = "the MDIForm property of the CClevRes Class for form '" _
          & sFormName & "' has been set even though this form is not an MDIChild."
         sSolution = "If you want '" & sFormName & "' to be an MDIChild then set it's " _
          & "MDIChild property to True."
      Case 105
      Case 106
         sProblem = "the " & vntOtherInfo & " of the CClevRes Class was attempted to be used " _
          & "before the Form property for that instance of the class was set."
         sSolution = "If the form is not an MDI child then at the beginning of it's " _
          & "Form_Load event set the CClevRes.Form property. "
         sSolution = sSolution & "If the form is an MDI child then at the beginning of it's " _
          & "Form_Load event first set the CClevRes.MDIForm property, then set the form's original " _
          & "width and height sizes (in twips), only after this should the Form property be set."
      Case 107
         sProblem = "the property '" & vntOtherInfo & "' was attempted to be set using " _
          & "an object which is supposed to be a control. However it does not seam to be " _
          & "a control since it does not have a Name property."
         sSolution = "If the object is a control array an index must be included in order " _
          & "to refere to just one control in the array."
      Case 108
         sProblem = "a control on an SSTab cannot be made exclusively resizable."
         sSolution = "Individually restrict all the other controls on the tab of the SSTab " _
          & "on which this particular control is required to be made exclusively resizable."
      Case 109
         sProblem = "the object which you wanted to pass to the CClevRes Class as a control" _
          & " does not seam to have been set."
         sSolution = "Make sure that this object is correctly set to one of the controls " _
          & "on form '" & sFormName & "' before passing it to the CClevRes Class."
   End Select
   HelpfulMsgBox sFormName, sProblem, sSolution
End Sub


